// ***********************************************************************
//
// List implementation of a Stack
//
// ***********************************************************************
// Computer Science 102: Data Structures
// New York University, Fall 2013,
//
// Lecturers: Eric Koskinen and Daniel Schwartz-Narbonne
//
// ***********************************************************************

public class StackList<E> implements Stack<E> {

    // Represent the stack as a generic list
    private MyList<E> list;
    public StackList() { list = new MyList<E>(); }

    // Basic operations
    public int size() {
        return list.size();
    }
    public boolean isEmpty() {
        return list.isEmpty();
    }

    // The Push() operation simply inserts the element at the front of the list
    public void push(E element) {
        list.insertFront(element);
    }

    // The Pop() operation simply removes the element from the front of the list
    // (IF the list is empty, it throws an exception)
    public E pop() throws InvalidOperationException {
        if (!isEmpty()) {
            return list.removeFront();
        } else {
            throw new InvalidOperationException("Stack empty: nothing to pop");
        }
    }

    // Output operations
    public String toString() {
        return  "TOP: "+list.toString();
    }
    public void PrettyPrint() {
	System.out.println(this.toString());
    }
}